/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.ParamPreReqHAConfig;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class SystemComponent
extends Component {
    private String m_operation;
    private boolean m_toCheckUserEquiv = false;
    private String m_product;
    private String m_release;
    private String m_osdba;
    private String m_asmgrp;
    private String m_oraInv;
    private String m_oracleHome;
    VerificationType m_preReqVerificationType = null;
    private ParamPreReq m_paramPreReq = null;
    private boolean m_healthCheck = false;

    SystemComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        switch (this.m_verificationType) {
            case 3: {
                this.m_product = this.getProduct();
                if (this.m_product == null) {
                    this.m_product = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_PRODUCT);
                }
                this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
                this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                if ("crs".equals(this.m_product)) {
                    this.m_oraInv = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
                    this.m_paramPreReq = new ParamPreReqCRSInst();
                    this.m_preReqVerificationType = VerificationType.SYSREQ_CRS;
                    ((ParamPreReqCRSInst)this.m_paramPreReq).setRelease(this.m_release);
                    if (this.m_osdba == null) {
                        this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                    }
                    if (this.m_oraInv == null) {
                        this.m_oraInv = VerificationUtil.getDefaultOraInvGroup();
                    }
                    if (this.m_osdba != null) {
                        ((ParamPreReqCRSInst)this.m_paramPreReq).setOSDBAgroup(this.m_osdba);
                    }
                    if (this.m_oraInv == null) break;
                    ((ParamPreReqCRSInst)this.m_paramPreReq).setORAINVgroup(this.m_oraInv);
                    break;
                }
                if ("database".equals(this.m_product)) {
                    this.m_paramPreReq = new ParamPreReqDBInst();
                    this.m_preReqVerificationType = VerificationType.SYSREQ_DB;
                    if (!this.m_healthCheck && this.m_osdba == null) {
                        this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                    }
                    this.m_oraInv = VerificationUtil.getOraInventoryGroup();
                    ((ParamPreReqDBInst)this.m_paramPreReq).setRelease(this.m_release);
                    if (this.m_osdba != null) {
                        ((ParamPreReqDBInst)this.m_paramPreReq).setOSDBAgroup(this.m_osdba);
                    }
                    if (this.m_oraInv == null) break;
                    ((ParamPreReqDBInst)this.m_paramPreReq).setOraInv(this.m_oraInv);
                    break;
                }
                if (!"ha".equals(this.m_product)) break;
                this.m_oraInv = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
                this.m_paramPreReq = new ParamPreReqHAConfig();
                this.m_preReqVerificationType = VerificationType.SYSREQ_SI_HA;
                if (this.m_osdba == null) {
                    this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                }
                if (this.m_oraInv == null) {
                    this.m_oraInv = VerificationUtil.getDefaultOraInvGroup();
                }
                if (this.m_osdba != null) {
                    ((ParamPreReqHAConfig)this.m_paramPreReq).setOSDBA(this.m_osdba);
                }
                if (this.m_oraInv == null) break;
                ((ParamPreReqHAConfig)this.m_paramPreReq).setOraInv(this.m_oraInv);
                break;
            }
            case 4: {
                this.m_operation = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_OPERATION);
                this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
                this.m_asmgrp = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ASMGRP);
                this.m_oraInv = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
                this.m_oracleHome = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLEHOME);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"=== ParamManager returned operation=%s, OSDBA=%s, ORAINV=%s, OracleHome=%s", (Object[])new Object[]{this.m_operation, this.m_osdba, this.m_oraInv, this.m_oracleHome});
                }
                this.m_toCheckUserEquiv = true;
            }
        }
    }

    @Override
    protected boolean checkSetup() {
        boolean succ = false;
        if (this.m_toCheckUserEquiv && this.m_verificationType == 4) {
            String[] nodeList = this.getNodeList();
            String[] validNodeList = new String[nodeList.length];
            System.arraycopy(nodeList, 0, validNodeList, 0, validNodeList.length);
            this.setValidNodeList(validNodeList);
            succ = true;
        } else {
            succ = super.checkSetup();
        }
        return succ;
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 3: {
                try {
                    List<Task> taskList = TaskFactory.getInstance().getTaskList(this.m_preReqVerificationType, validNodeArr, this.m_paramPreReq);
                    for (Task task : taskList) {
                        if (task.hasSubtasks()) {
                            List<VerificationTask> subTaskList = task.getSubtasks();
                            for (VerificationTask subTask : subTaskList) {
                                VerificationResultSet vrset = subTask.verify();
                                retval &= ((ResultSet)vrset).allSuccess();
                                if (Trace.isLevelEnabled((int)1)) {
                                    Trace.out((String)("\n>>>> SystemComponent:: Upload SubTask=" + subTask.getElementName() + "results >>>>>\n"));
                                }
                                this.m_resultSet.uploadResultSet((ResultSet)vrset);
                            }
                            continue;
                        }
                        retval &= task.perform();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("\n>>>> SystemComponent:: Upload Task=" + task.getElementName() + "results >>>>>\n"));
                        }
                        this.m_resultSet.uploadResultSet(task.getResultSet());
                    }
                }
                catch (TaskFactoryException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                    ReportUtil.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (VerificationException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                return retval;
            }
            case 4: {
                TaskAdminPrivileges taskAP = new TaskAdminPrivileges(validNodeArr, this.m_operation);
                taskAP.setOSDBA(this.m_osdba);
                taskAP.setOraInv(this.m_oraInv);
                taskAP.setCheckUserEquiv(this.m_toCheckUserEquiv);
                taskAP.setOracleHome(this.m_oracleHome);
                taskAP.setASMADMIN(this.m_asmgrp);
                retval &= taskAP.perform();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"\n>>>> SystemComponent:: Upload taskAP >>>>>\n");
                }
                this.m_resultSet.uploadResultSet(taskAP.getResultSet());
                return retval;
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getProduct() {
        return this.m_product;
    }

    public void setProduct(String product) {
        this.m_product = product;
    }

    @Override
    public String getComponentName() {
        return "SYS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9968", false);
    }

    public void setHealthCheck(boolean healthCheck) {
        this.m_healthCheck = healthCheck;
    }
}

